/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.awt.Component;
import java.awt.Container;
import net.java.dev.designgridlayout.AbstractClassBasedHeightGrowPolicy;
import net.java.dev.designgridlayout.HeightGrowPolicy;

class ContainerHeightGrowPolicy
extends AbstractClassBasedHeightGrowPolicy<Container> {
    private final HeightGrowPolicy _defaultPolicy;

    public ContainerHeightGrowPolicy(HeightGrowPolicy defaultPolicy) {
        super(Container.class);
        this._defaultPolicy = defaultPolicy;
    }

    @Override
    protected boolean componentCanGrowHeight(Container panel) {
        for (Component child : panel.getComponents()) {
            if (!this._defaultPolicy.canGrowHeight(child)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int componentComputeExtraHeight(Container panel, int extraHeight) {
        int actualHeight = 0;
        for (Component child : panel.getComponents()) {
            if (!this._defaultPolicy.canGrowHeight(child)) continue;
            actualHeight = Math.max(actualHeight, this._defaultPolicy.computeExtraHeight(child, extraHeight));
        }
        return actualHeight;
    }
}

